import numpy as np
from scipy.spatial.distance import cdist


def get_correlation(prediction, target):
    import scipy.stats as stats

    rmse = np.sqrt(((prediction - target) ** 2).mean())
    rho, _ = stats.spearmanr(prediction, target)
    tau, _ = stats.kendalltau(prediction, target)

    return rmse, rho, tau


def all_except(x, *args):
    if len(args) == 0:
        return x
    else:
        H = set(args) if len(args) > 5 else args
        I = [k for k in range(len(x)) if k not in H]
        return x[I]



def is_duplicate(X, eps=1e-16):
    D = cdist(X, X)
    D[np.triu_indices(len(X))] = np.inf

    I = np.full(len(X), False)
    I[np.any(D < eps, axis=1)] = True
    return I


def to_list(v):
    if not isinstance(v, list):
        v = [v]
    return v


def at_least2d(x, expand="c"):
    if x.ndim == 1:
        if expand == "c":
            return x[:, None]
        elif expand == "r":
            return x[None, :]
    else:
        return x

def empty_dict_if_none(x):
    if x is None:
        return {}
    else:
        return x