import copy


def create_models(*clazz_and_hyperparameter, defaults={}):
    ret = []
    for clazz, params in clazz_and_hyperparameter:

        name = clazz.__name__
        for entry in dfs(params):
            ret.append((name, clazz, entry, dict(defaults)))

    return ret


def dfs(hyperparams):
    ret = []
    dfs_rec({}, hyperparams, ret)
    return ret


def dfs_rec(combination, hyperparams, ret):
    if len(hyperparams) == 0:
        ret.append(combination)
    else:
        _params = copy.deepcopy(hyperparams)
        key = list(hyperparams.keys())[0]
        del _params[key]

        for value in hyperparams[key]:
            _comb = copy.deepcopy(combination)
            _comb[key] = value

            dfs_rec(_comb, _params, ret)


def all_models(defaults={}):
    from surrogate.models.dnn import DNN
    from surrogate.models.kriging import Kriging
    from surrogate.models.rbf import RBF

    MODELS = [Kriging, RBF, DNN]

    clazz_and_hyperparameter = [(model, model.hyperparameters()) for model in MODELS]
    return create_models(*clazz_and_hyperparameter, defaults=defaults)
