import matplotlib.pyplot as plt

from surrogate.custom.regression import RidgeRegression
from surrogate.util.sample import linear_function

model = RidgeRegression()

# create some data to test this model on
X, y, _X, _y = linear_function(100, 200, noise=0.4)

# let the model fit the data
model.fit(X, y)

# predict the data using the model
y_hat = model.predict(_X)

plt.scatter(X, y, label="Data")
plt.plot(_X, y_hat, color="black", label="Ridge")
plt.legend()
plt.show()
