import matplotlib.pyplot as plt
import numpy as np

from surrogate.custom.regression import QuadraticRegression
from surrogate.util.sample import square_function

# build the model to be used
model = QuadraticRegression()

# create some data to test this model on
X, y, _X, _y = square_function(100, 200, noise=1, n_var=1)

# let the model fit the data
model.fit(X, y)

# predict the data using the model
_X = _X[np.argsort(_X[:, 0])]
y_hat = model.predict(_X)

plt.scatter(X, y, label="Data")
plt.plot(_X, y_hat, color="black", label="Regression")
plt.legend()
plt.show()
