import matplotlib.pyplot as plt
import numpy as np

from surrogate.models.rbf import RBF
from surrogate.util.sample import sine_function

# create the radial basis function model
rbf = RBF()

# create some data to test this model on
X, y, _X, _y = sine_function(20, 200)

# let the model fit the data
rbf.fit(X, y)

# predict the data using the model
y_hat = rbf.predict(_X)

# predict the data using the model
_X = _X[np.argsort(_X[:, 0])]
y_hat = rbf.predict(_X)

plt.scatter(X, y, label="Data")
plt.plot(_X, y_hat, color="black", label="RBF")
plt.legend()
plt.show()
