import matplotlib.pyplot as plt
import numpy as np

from surrogate.models.rbf import RBF
from surrogate.models.kriging import Kriging
from surrogate.selection import ModelSelection
from surrogate.util.sample import square_function

# create some data to test this model on
X, y, _X, _y = square_function(20, 200, n_var=1)

# select the best model from the given options
model = ModelSelection(RBF, Kriging).do(X, y)
print(model)

# predict the data using the model
y_hat = model.predict(_X)

# predict the data using the model
_X = _X[np.argsort(_X[:, 0])]
y_hat = model.predict(_X)

plt.scatter(X, y, label="Data")
plt.plot(_X, y_hat, color="black", label="Regression")
plt.legend()
plt.show()
