from surrogate.metrics import calc_metric
from surrogate.models.kriging import Kriging
from surrogate.util.sample import sine_function

# initialize the model
model = Kriging(regr="linear",
                corr="gauss",
                ARD=False)

# create some data to test this model on
X, y, _X, _y = sine_function(100, 20)

# let the model fit the data
model.fit(X, y)

# predict the data using the model
y_hat, y_var = model.predict(_X, return_values_of=["y", "var"])

# calculate the error and print it
mae = calc_metric("mae", _y, y_hat)
print("Mean Absolute Error", mae)
