from surrogate.metrics import calc_metric
from surrogate.models.dnn import DNN
from surrogate.util.sample import sine_function

# initialize the model
dnn = DNN(epochs=1000,
          n_hidden=300,
          lr=8e-4,
          drop_rate=0.2,
          device="cpu")

# create some data to test this model on
X, y, _X, _y = sine_function(200, 20)

# let the model fit the data
dnn.fit(X, y)

# predict the data using the model
y_hat = dnn.predict(_X)

# calculate the error and print it
mae = calc_metric("mae", _y, y_hat)
print("Mean Absolute Error", mae)
print("Time: ", dnn.time)
