import numpy as np

from surrogate.benchmark import Benchmark
from surrogate.models.rbf import RBF
from surrogate.partitioning.random import RandomPartitioning

# create some data to benchmark on
X = np.random.random((100, 1)) * 2 * np.pi
y = np.sin(X)

# set up the benchmark and add the models to be used
benchmark = Benchmark(n_threads=4, verbose=True)
benchmark.add_models(RBF)
# benchmark.add_models(Kriging)

# create partitions to validate the performance of each model
partitions = RandomPartitioning(X, 50, 20, n_sets=2, seed=1).do()

# runs the experiment with the specified partitioning
benchmark.do(X, y, partitions=partitions)

# print out the benchmark results
benchmark.print()
