import random

import numpy as np


class Partitioning:

    def __init__(self, X, n_sets=None, seed=None) -> None:
        super().__init__()
        self.X = X
        self.n_sets = n_sets
        self.seed = seed

    def do(self):
        if self.seed is not None:
            random.seed(self.seed)
            np.random.seed(self.seed)

        if self.n_sets is None:
            return self._do()
        else:
            ret = []
            for _ in range(self.n_sets):
                ret.append(self._do())
            return ret

    def _do(self):
        pass










