import GPy
import numpy as np
from sklearn.gaussian_process import GaussianProcessRegressor
from sklearn.gaussian_process.kernels import ConstantKernel, Matern

from surrogate.model import Model


class sklearnGP(Model):

    def __init__(self,
                 kernel=ConstantKernel(1.0) * Matern(length_scale=1.0, nu=2.5),
                 noise=1e-4,
                 **kwargs) -> None:
        super().__init__(**kwargs)
        self.model = GaussianProcessRegressor(kernel=kernel, alpha=noise)

    def _fit(self, X, y, **kwargs):
        self.model.fit(X, y)

    def _predict(self, X, out):
        if "sigma" in out:
            out["y"], sigma = self.model.predict(X, return_std=True)

            sigma[sigma <= 0] = 0
            out["sigma"] = sigma.reshape(-1, 1)
        else:
            out["y"] = self.model.predict(X)


class gpyGP(Model):

    def __init__(self, **kwargs) -> None:
        super().__init__(**kwargs)

    def _fit(self, X, y, **kwargs):
        kernel = GPy.kern.Matern52(input_dim=X.shape[1], ARD=False)
        self.model = GPy.models.GPRegression(X, y, kernel, normalizer=True)

    def _predict(self, X, out):
        if "sigma" in out:
            out["y"], var = self.model.predict(X)

            var[var <= 0] = 0
            out["var"] = var
            out["sigma"] = np.sqrt(var)
        else:
            out["y"], _ = self.model.predict(X)

    def _optimize(self, **kwargs):
        model = self.model

        model.constrain_positive('')
        (kern_variance, kern_lengthscale, gaussian_noise) = model.parameter_names()

        model[kern_variance].constrain_bounded(1e-6, 1e6, warning=False)
        model[kern_lengthscale].constrain_bounded(1e-6, 1e6, warning=False)
        model[gaussian_noise].constrain_fixed(1e-6, warning=False)

        model.optimize_restarts(optimizer='lbfgs',
                                num_restarts=10,
                                num_processes=1,
                                verbose=False)

