import setuptools
from setuptools import setup

from surrogate.version import __version__

__name__ = "surrogate-toolbox"
__author__ = "Julian Blank"
__url__ = ""

install_requires=['numpy>=1.15', "scipy", "pydacefit", "pySOT==0.2.3"]

extras_require = {
    'core': install_requires,
    'full': install_requires + ['gpflow', 'torch', 'torchvision']
}

data = dict(
    name=__name__,
    version=__version__,
    author=__author__,
    url=__url__,
    python_requires='>=3.6',
    author_email="blankjul@egr.msu.edu",
    description="Surrogate Models, Metamodels, Response Surface",
    license='Apache License 2.0',
    keywords="optimization",
    install_requires=install_requires,
    extras_require=extras_require,
    include_package_data=True,
    platforms='any',
    classifiers=[
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Topic :: Scientific/Engineering',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'Topic :: Scientific/Engineering :: Mathematics'
    ]
)


# ---------------------------------------------------------------------------------------------------------
# OTHER METADATA
# ---------------------------------------------------------------------------------------------------------


# update the readme.rst to be part of setup
def readme():
    with open('README.rst') as f:
        return f.read()


def packages():
    return ["surrogate"] + ["surrogate." + e for e in setuptools.find_packages(where='surrogate')]


data['long_description'] = readme()
data['long_description_content_type'] = 'text/x-rst'
data['packages'] = packages()

# ---------------------------------------------------------------------------------------------------------
# SETUP
# ---------------------------------------------------------------------------------------------------------

setup(**data)
