import setuptools

# ---------------------------------------------------------------------------------------------------------
# GENERAL
# ---------------------------------------------------------------------------------------------------------


__name__ = "pycheapconstr"
__author__ = "Julian Blank"
__url__ = ""

data = dict(
    name=__name__,
    version="1.0",
    author=__author__,
    url=__url__,
    python_requires='>=3.6',
    author_email="blankjul@egr.msu.edu",
    description="Surrogate-Assisted Multi-objective Optimization",
    license='Apache License 2.0',
    keywords="surrogate, metamodel, bayesian optimization",
    install_requires=["pymoo", "surrogate-toolbox"],
    platforms='any',
    classifiers=[
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Topic :: Scientific/Engineering',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'Topic :: Scientific/Engineering :: Mathematics'
    ]
)


# ---------------------------------------------------------------------------------------------------------
# METADATA
# ---------------------------------------------------------------------------------------------------------


def packages():
    return ["pycheapconstr"] + ["pycheapconstr." + e for e in setuptools.find_packages(where='pycheapconstr')]

data['packages'] = packages()

setuptools.setup(**data)
