from pycheapconstr.algorithms.icsansga2 import ICSANSGA2
from pycheapconstr.algorithms.sansga2 import SANSGA2
from pymoo.algorithms.nsga2 import NSGA2
from pymoo.factory import CTP2
from pymoo.optimize import minimize
from pymoo.visualization.scatter import Scatter


class CTP2WithCheapConstraints(CTP2):

    def _evaluate(self, x, out, *args, only_inexpensive_constraints=False, **kwargs):

        if only_inexpensive_constraints:
            d = {}
            super()._evaluate(x, d, *args, **kwargs)
            out["G"] = d["G"]
        else:
            super()._evaluate(x, out, *args, **kwargs)


problem = CTP2WithCheapConstraints()

pf = problem.pareto_front()

algorithm = NSGA2(pop_size=11 * problem.n_var - 1, n_offsprings=5)

n_evals = 200

res = minimize(problem,
               algorithm,
               ('n_evals', n_evals),
               seed=1,
               pf=pf,
               verbose=True)

algorithm = SANSGA2(n_offsprings=5)

sa_res = minimize(problem,
                  algorithm,
                  ('n_evals', n_evals),
                  seed=1,
                  pf=pf,
                  verbose=True)

algorithm = ICSANSGA2(n_offsprings=5)
ic_sa_res = minimize(problem,
                     algorithm,
                     ('n_evals', n_evals),
                     seed=1,
                     pf=pf,
                     verbose=True)

plot = Scatter(legend=True)
plot.add(pf, plot_type="line", color="black", alpha=0.7)

plot.add(res.F, label="NSGA2", s=80, facecolors='none', edgecolors='r', marker="o")
plot.add(sa_res.F, label="SA-NSGA2", facecolors='none', edgecolors='b', marker="^")
plot.add(ic_sa_res.F, label="IC-SA-NSGA2", facecolors='none', edgecolors='g', marker="H")
plot.show()
