from pycheapconstr.algorithms.icsansga2 import ICSANSGA2
from pymoo.factory import CTP2
from pymoo.optimize import minimize
from pymoo.visualization.scatter import Scatter


class CTP2WithCheapConstraints(CTP2):

    def _evaluate(self, x, out, *args, only_inexpensive_constraints=False, **kwargs):

        if only_inexpensive_constraints:
            d = {}
            super()._evaluate(x, d, *args, **kwargs)
            out["G"] = d["G"]
        else:
            super()._evaluate(x, out, *args, **kwargs)


problem = CTP2WithCheapConstraints()

n_evals = 200

algorithm = ICSANSGA2(n_offsprings=5)
res = minimize(problem,
             algorithm,
             ('n_evals', n_evals),
             seed=1,
             verbose=True)

plot = Scatter(legend=True)
plot.add(res.F, label="IC-SA-NSGA2", facecolors='none', edgecolors='g', marker="H")
plot.show()
