import os
import pickle

from pycheapconstr.algorithms.icsansga2 import ICSANSGA2
from pycheapconstr.algorithms.sansga2 import SANSGA2
from pycheapconstr.misc.car import MyCarside
from pymoo.algorithms.nsga2 import NSGA2
from pymoo.factory import get_problem, get_reference_directions

ref_dirs = get_reference_directions("das-dennis", 2, n_points=100)

setup = {

    'ctp1': {
        'termination': ('n_eval', 200),
        'problem': get_problem("ctp1", n_var=10)
    },

    'ctp2': {
        'termination': ('n_eval', 200),
        'problem': get_problem("ctp2", n_var=10),
    },

    'ctp3': {
        'termination': ('n_eval', 200),
        'problem': get_problem("ctp3", n_var=10),
    },

    'ctp4': {
        'termination': ('n_eval', 400),
        'problem': get_problem("ctp4", n_var=10),
    },

    'ctp5': {
        'termination': ('n_eval', 400),
        'problem': get_problem("ctp5", n_var=10),
    },

    'ctp6': {
        'termination': ('n_eval', 400),
        'problem': get_problem("ctp6", n_var=10),
    },
    'ctp7': {
        'termination': ('n_eval', 400),
        'problem': get_problem("ctp7", n_var=10),
    },

    'ctp8': {
        'termination': ('n_eval', 400),
        'problem': get_problem("ctp8", n_var=10),
    },

    'srn': {
        'termination': ('n_eval', 200),
        'problem': get_problem("srn")
    },

    'tnk': {
        'termination': ('n_eval', 200),
        'problem': get_problem("tnk")
    },

    'osy': {
        'termination': ('n_eval', 500),
        'problem': get_problem("osy")
    },
    'car': {
        'termination': ('n_eval', 200),
        'problem': MyCarside(),
    },
    'c2dtlz2': {
        'termination': ('n_eval', 200),
        'problem': get_problem("c2dtlz2", n_obj=2),
        'pf': get_problem("c3dtlz4", n_obj=2).pareto_front(ref_dirs)
    },
    'c3dtlz4': {
        'termination': ('n_eval', 200),
        'problem': get_problem("c3dtlz4", n_obj=2),
        'pf': get_problem("c3dtlz4", n_obj=2).pareto_front(ref_dirs)
    }

}

if __name__ == '__main__':

    for name, func_algorithm in [
        ("nsga2", lambda problem: NSGA2(pop_size=11 * problem.n_var - 1, n_offsprings=5)),
        ("sansga2", lambda problem: SANSGA2()),
        ("icsansga2", lambda problem: ICSANSGA2())
    ]:

        # all the files to be run in a list
        run_files = []

        # prefix of the folder to save the files
        prefix = "runs"

        # number of runs to execute
        n_runs = 11

        # single to be investigated
        problems = setup.keys()

        # path were the files for this experiment are saved
        path = os.path.join(prefix, name)

        for _problem in problems:

            s = setup[_problem]
            problem = s['problem']

            # the algorithm to be used
            algorithm = func_algorithm(problem)

            termination = s['termination']

            for run in range(1, n_runs + 1):
                fname = "%s_%s.run" % (_problem, run)
                _in = os.path.join(path, fname)
                _out = "results/%s/%s/%s_%s.out" % (name, _problem.replace("_", "/"), _problem, run)

                data = {
                    'args': [problem, algorithm, termination],
                    'kwargs': {
                        'seed': run,
                    },
                    'in': _in,
                    'out': _out,
                }

                os.makedirs(os.path.join(os.path.dirname(_in)), exist_ok=True)

                with open(_in, 'wb') as f:
                    pickle.dump(data, f)
                    run_files.append(data)

            # create the final run.txt file
            with open(os.path.join(prefix, name, "run.bat"), 'w') as f:
                for run_file in run_files:
                    f.write("python execute.py %s %s\n" % (run_file['in'], run_file['out']))
